using System;
using Server.Targeting;
using Server;

namespace Server.Items
{
	public class IngotTransmutationHammer : BaseBashing, IUsesRemaining
	{
		private int m_UsesRemaining;

		[CommandProperty( AccessLevel.GameMaster )]
		public int UsesRemaining
		{
			get { return m_UsesRemaining; }
			set { m_UsesRemaining = value; InvalidateProperties(); }
		}

		public bool ShowUsesRemaining{ get{ return true; } set{} }

		public override WeaponAbility PrimaryAbility{ get{ return WeaponAbility.CrushingBlow; } }
		public override WeaponAbility SecondaryAbility{ get{ return WeaponAbility.ShadowStrike; } }

		public override int AosStrengthReq{ get{ return 40; } }
		public override int AosMinDamage{ get{ return 13; } }
		public override int AosMaxDamage{ get{ return 15; } }
		public override int AosSpeed{ get{ return 33; } }

		public override int OldStrengthReq{ get{ return 10; } }
		public override int OldMinDamage{ get{ return 6; } }
		public override int OldMaxDamage{ get{ return 8; } }
		public override int OldSpeed{ get{ return 33; } }
		
      [Constructable]
		public IngotTransmutationHammer() : this( 200 )
		{
		}
		[Constructable]
		public IngotTransmutationHammer( int uses ) : base( 0xFB4 )
		{
			Weight = 9.0;
			UsesRemaining = uses;
			Name = "ingot transmutation hammer";
		}

		public IngotTransmutationHammer( Serial serial ) : base( serial )
		{
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( IsChildOf( from.Backpack ) || Parent == from )
			{
            from.SendMessage( "Vyber ingoty pro transmutaci" );
            from.Target = new InternalTarget( this );
         }
			else
				from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
		}

		public void Transmute( Mobile from, object o )
		{
			if ( !IsChildOf( from.Backpack ) && Parent != from )
			{
				from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
				return;
			}
			else if ( !(o is BaseIngot) )
			{
			   from.SendMessage( "ingot transmutation hammer lze pouzit pouze na ingoty" );
				return;
			}
			else if( !((Item)o).IsChildOf(from.Backpack) )
			{
			   from.SendMessage( "Ingoty musis mit v batohu" );
				return;
			}
			else if ( o is BloodstoneIngot )
			{
			   from.SendMessage( "Bloodstone ingot jiz nelze vylepsit" );
				return;
			}
         else
         {
			   Item stary = o as Item;
			   Item novy = null;
			   
            if ( stary is IronIngot )
               novy = new DullCopperIngot();
            else if ( stary is DullCopperIngot )
               novy = new ShadowIronIngot();
            else if ( stary is ShadowIronIngot )
                novy = new CopperIngot();
            else if ( stary is CopperIngot )
               novy = new BronzeIngot();
            else if ( stary is BronzeIngot )
               novy = new GoldIngot();
            else if ( stary is GoldIngot )
               novy = new AgapiteIngot();
            else if ( stary is AgapiteIngot )
               novy = new VeriteIngot();
            else if ( stary is VeriteIngot )
               novy = new ValoriteIngot();
            else if ( stary is ValoriteIngot )
               novy = new SilverIngot();
            else if ( stary is SilverIngot )
               novy = new PlatinumIngot();
            else if ( stary is PlatinumIngot )
               novy = new MythrilIngot();
            else if ( stary is MythrilIngot )
               novy = new ObsidianIngot();
            else if ( stary is ObsidianIngot )
               novy = new JadeIngot();
            else if ( stary is JadeIngot )
               novy = new MoonstoneIngot();
            else if ( stary is MoonstoneIngot )
               novy = new SunstoneIngot();
            else if ( stary is SunstoneIngot )
               novy = new BloodstoneIngot();
            else
               return;
               
            if ( UsesRemaining >= stary.Amount )
            {
               ((Item)novy).Amount = stary.Amount;
               stary.Delete();
               UsesRemaining -= ((Item)novy).Amount;
               from.AddToBackpack( (Item) novy );
            }
            else
            {
               ((Item)novy).Amount = UsesRemaining;
               ((Item)o).Amount -= UsesRemaining;
               UsesRemaining = 0;
               from.AddToBackpack( (Item) novy );
            }
            
            from.PlaySound( 0x244 );
            from.SendMessage( "Transmutace byla uspesne dokoncena" );
               
				if ( UsesRemaining <= 0 )
				{
					from.SendMessage( "ingot transmutation hammer byl vypotrebovan" );
					Delete();
				}
			}
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
			writer.Write( (int) m_UsesRemaining );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			m_UsesRemaining = reader.ReadInt();
		}

		private class InternalTarget : Target
		{
			private IngotTransmutationHammer m_Tool;

			public InternalTarget( IngotTransmutationHammer tool ) : base( 2, true, TargetFlags.None )
			{
				m_Tool = tool;
			}

			protected override void OnTarget( Mobile from, object targeted )
			{
				m_Tool.Transmute( from, targeted );
			}
		}
	}
}